function OnMsg.NewDay(day)
	local commander = GetCommanderProfile()
	if commander.name ~= "SelfHelpExpert" then
		return
	end
	local all_traits = DataInstances.Trait
	local num_perks = 0
	for _, colonist in ipairs(UICity.labels.Colonist or empty_table) do
		if IsValid(colonist) and not colonist:IsDying() then
			local isChild = false
			for trait in pairs(colonist.traits or empty_table) do
				if trait == "Child" then
					isChild = true
					break
				end
				local trait_def = all_traits[trait]
				if trait_def and trait_def.category == "Positive" then
					num_perks = num_perks + 1
				end
			end
			if not isChild then
				colonist:ChangeSanity(2*const.Scale.Stat)
				local sanity_bonus = colonist.stat_sanity / const.Scale.Stat - 80
				if sanity_bonus > 0 then
					for trait in pairs(colonist.traits or empty_table) do
						local trait_def = all_traits[trait]
						if trait_def and trait_def.category == "Negative" and colonist:Random(100) < sanity_bonus then
							colonist:RemoveTrait(trait)
						end
					end
					if colonist:Random(150 + 50 * num_perks) < sanity_bonus then
						local trait = GetRandomTrait(colonist.traits, {}, {}, "Positive", true, 0)
						if trait then
							colonist:AddTrait(trait)
						end
					end
				end
			end
		end
	end
end
